// /////////////////////////////////////////////////////////////////////////////
// DR DOBB'S CHALLENGES
//
// Filename       : EntityShodan.cpp
// Date           : February 2008
//
// Description    : Refer to description in corresponding header.
//
// ///////////////////////////////////////////////////////////////////////////


#include "EntityShodan.h"
#include "EntityPlayer.h"
#include "Level.h"
#include "Game.h"
#include "Application.h"




EntityShodan::EntityShodan() :
  m_AttackDelay( 0.0f ),
  m_Active( false )
{

  SetFrame( Dobbs::ANIM_SHODAN );
  m_Floating      = true;
  m_Health        = 30+20+10;
  m_CurAttackPos  = 0;

  SetRect( &m_CollisionRect, 0, 0, 100, 100 );

}



EntityShodan::~EntityShodan() 
{
}



void EntityShodan::OnEvent( const EntityEvent Event, int Param1, int Param2, const std::string& TextParam, Entity* pEntity )
{

  switch ( Event )
  {
    case EE_INIT:
      break;
    case EE_HURT:
      g_App.PlaySound( "Shodan.Hurt" );
      if ( m_State == 4 )
      {
        // shoot in player direction
        if ( m_pLevel->m_pPlayer )
        {
          int   DX = m_pLevel->m_pPlayer->GetX() - m_X;
          int   DY = m_pLevel->m_pPlayer->GetY() - m_Y;

          float Angle = atan2f( -(float)DY, (float)DX ) * 180.0f / 3.1415926f;

          for ( int i = -2; i <= 2; ++i )
          {
            Entity*   pShot = m_pLevel->SpawnEntity( Dobbs::ENTITY_TYPE_SHOT, 0, m_X + 50, m_Y + 50 );

            pShot->SetVelX( 200.0f * cosf( ( Angle + i * 10 ) * 3.1415926f / 180.0f ) );
            pShot->SetVelY( -200.0f * sinf( ( Angle + i * 10 ) * 3.1415926f / 180.0f ) );
          }
          g_App.PlaySound( "Laser.Shot" );
        }
      }
      {
        Entity* pShot = m_pLevel->SpawnEntity( Dobbs::ENTITY_TYPE_THROWN_TOKEN, 0, m_X + 50, m_Y + 120 );

        pShot->SetVelX( (float)( ( rand() % 21 ) - 10 ) );
      }
      if ( m_Health == 30 )
      {
        // teleport to upper area
        SetState( 1 );
        m_CurAttackPos = 0;
        g_App.PlaySound( "Shodan.Hit" );
      }
      else if ( m_Health == 10 )
      {
        // teleport to lower area
        SetState( 3 );
        m_CurAttackPos = 0;
        g_App.PlaySound( "Shodan.Hit" );
      }
      break;
    case EE_KILLED:
      // done, clear the alarm
      m_pLevel->SpawnEntity( Dobbs::ENTITY_TYPE_EXPLOSION, 0, GetX() + 50, GetY() + 50 );

      for ( int i = 0; i < 360; i += 30 )
      {
        m_pLevel->SpawnEntity( Dobbs::ENTITY_TYPE_EXPLOSION, 0, 
                               (int)( GetX() + 50 + 40.0f * cosf( i * 3.1415926f / 180.0f ) ),
                               (int)( GetY() + 50 + 40.0f * sinf( i * 3.1415926f / 180.0f ) ) );
      }
      g_App.PlaySound( "Player.Explode" );

      m_pLevel->m_pGame->OnGameEvent( Dobbs::GE_STOP_ALARM );
      m_pLevel->m_pGame->OnGameEvent( Dobbs::GE_SHODAN_KILLED );
      return;
  }
  Entity::OnEvent( Event, Param1, Param2, TextParam, pEntity );

}



void EntityShodan::UpdateTimed( Level& aLevel, float ElapsedTime )
{

  Entity::UpdateTimed( aLevel, ElapsedTime );

  if ( m_State == 1 )
  {
    // move up
    if ( m_StateTime >= 1.0f )
    {
      m_Y = 398;
      SetState( 2 );
    }
    else
    {
      m_Y = 1102 + (int)( ( 398 - 1102 ) * m_StateTime / 1.0f );
    }
  }
  else if ( m_State == 3 )
  {
    // move down
    if ( m_StateTime >= 1.0f )
    {
      m_Y = 1102;
      SetState( 4 );
    }
    else
    {
      m_Y = 398 + (int)( ( 1102 - 398 ) * m_StateTime / 1.0f );
    }
  }

  if ( m_Active )
  {
    m_AttackDelay += ElapsedTime;
    switch ( m_State )
    {
      case 0:
        if ( m_AttackDelay >= 2.5f )
        {
          m_AttackDelay -= 2.5f;
          m_CurAttackPos = 1 - m_CurAttackPos;

          for ( int i = -3; i <= 3; ++i )
          {
            Entity*   pShot = m_pLevel->SpawnEntity( Dobbs::ENTITY_TYPE_SHOT, 0, m_X + 50, m_Y + 50 );

            pShot->SetVelX( 100.0f * cosf( ( -90.0f + i * 20 + ( m_CurAttackPos % 2 ) * 10 ) * 3.1415926f / 180.0f ) );
            pShot->SetVelY( -100.0f * sinf( ( -90.0f + i * 20 + ( m_CurAttackPos % 2 ) * 10 ) * 3.1415926f / 180.0f ) );
          }
          g_App.PlaySound( "Laser.Shot" );
        }
        break;
      case 2:
        if ( m_AttackDelay >= 0.15f )
        {
          m_AttackDelay -= 0.15f;
          m_CurAttackPos = ( m_CurAttackPos + 1 ) % 28;

          if ( m_CurAttackPos < 7 )
          {
            Entity*   pShot = m_pLevel->SpawnEntity( Dobbs::ENTITY_TYPE_SHOT, 0, m_X + 50, m_Y + 50 );

            pShot->SetVelX( 100.0f * cosf( ( -90.0f + ( m_CurAttackPos - 3 ) * 20 ) * 3.1415926f / 180.0f ) );
            pShot->SetVelY( -100.0f * sinf( ( -90.0f + ( m_CurAttackPos - 3 ) * 20 ) * 3.1415926f / 180.0f ) );
          }
          else if ( ( m_CurAttackPos >= 14 )
          &&        ( m_CurAttackPos < 21 ) )
          {
            Entity*   pShot = m_pLevel->SpawnEntity( Dobbs::ENTITY_TYPE_SHOT, 0, m_X + 50, m_Y + 50 );

            pShot->SetVelX( 100.0f * cosf( ( -90.0f + ( 3 - m_CurAttackPos + 14 ) * 20 ) * 3.1415926f / 180.0f ) );
            pShot->SetVelY( -100.0f * sinf( ( -90.0f + ( 3 - m_CurAttackPos + 14 ) * 20 ) * 3.1415926f / 180.0f ) );
          }
          g_App.PlaySound( "Laser.Shot" );
        }
        break;
      case 4:
        break;
    }
  }

}



bool EntityShodan::Hit()
{

  if ( ( m_State == 0 )
  ||   ( m_State == 2 )
  ||   ( m_State == 4 ) )
  {
    return Entity::Hit();
  }
  return false;

}